/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.filesystem.ftp.internal;

import com.aptana.core.io.vfs.ExtendedFileInfo;
import com.aptana.core.util.ExpiringMap;
import com.aptana.filesystem.ftp.FTPPlugin;
import com.aptana.filesystem.ftp.IFTPConnectionFileManager;
import com.aptana.filesystem.ftp.Policy;
import com.aptana.filesystem.ftp.internal.BaseFTPConnectionFileManager;
import com.aptana.filesystem.ftp.internal.FTPClientPool;
import com.aptana.filesystem.ftp.internal.FTPFileDownloadInputStream;
import com.aptana.filesystem.ftp.internal.FTPFileUploadOutputStream;
import com.aptana.filesystem.ftp.internal.IPoolConnectionManager;
import com.aptana.filesystem.ftp.internal.Messages;
import com.aptana.ide.core.io.ConnectionContext;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.PermissionDeniedException;
import com.aptana.ide.core.io.preferences.PermissionDirection;
import com.aptana.ide.core.io.preferences.PreferenceUtils;
import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPConnectionClosedException;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileFactory;
import com.enterprisedt.net.ftp.FTPInputStream;
import com.enterprisedt.net.ftp.FTPMessageListener;
import com.enterprisedt.net.ftp.FTPOutputStream;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileTransferInputStream;
import com.enterprisedt.net.ftp.FileTransferOutputStream;
import com.enterprisedt.net.ftp.MalformedReplyException;
import com.enterprisedt.net.ftp.pro.ProFTPClient;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Status;

public class FTPConnectionFileManager
extends BaseFTPConnectionFileManager
implements IFTPConnectionFileManager,
IPoolConnectionManager {
    private static final String TMP_TIMEZONE_CHECK = "_tmp_tz_check";
    private static final String WINDOWS_STR = "WINDOWS";
    private static final SimpleDateFormat[] UTIME_FORMATS = new SimpleDateFormat[]{new SimpleDateFormat("'UTIME' yyyyMMddHHmmss '{0}'"), new SimpleDateFormat("'UTIME {0}' yyyyMMddHHmmss yyyyMMddHHmmss yyyyMMddHHmmss 'UTC'")};
    protected FTPClient ftpClient;
    private List<String> serverFeatures;
    protected String transferType;
    protected String timezone;
    protected IPath cwd;
    private FTPFileFactory fileFactory;
    private Boolean statSupported = null;
    private Boolean listASupported = null;
    private int utimeFormat = -1;
    private Map<IPath, FTPFile> ftpFileCache = new ExpiringMap(60000L);
    private long serverToLocalTimeZoneShift = Integer.MIN_VALUE;
    protected boolean hasServerInfo;
    protected PrintWriter messageLogWriter;
    protected FTPClientPool pool;

    public void init(String host, int port, IPath basePath, String login, char[] password, boolean passive, String transferType, String encoding, String timezone) {
        Assert.isTrue((this.ftpClient == null ? 1 : 0) != 0, (String)Messages.FTPConnectionFileManager_already_initialized);
        try {
            this.pool = new FTPClientPool(this);
            this.ftpClient = new ProFTPClient();
            this.host = host;
            this.port = port;
            this.login = login;
            this.password = password == null ? EMPTY_PASSWORD : password;
            this.basePath = basePath != null ? basePath : Path.ROOT;
            this.authId = Policy.generateAuthId("FTP", login, host, port);
            this.transferType = transferType;
            this.timezone = timezone != null && timezone.length() == 0 ? null : timezone;
            FTPConnectionFileManager.initFTPClient(this.ftpClient, passive, encoding);
        }
        catch (Exception e) {
            FTPPlugin.log((IStatus)new Status(2, "com.aptana.filesystem.ftp", Messages.FTPConnectionFileManager_initialization_failed, (Throwable)e));
            this.ftpClient = null;
        }
    }

    protected static void initFTPClient(FTPClient ftpClient, boolean passive, String encoding) throws IOException, FTPException {
        ftpClient.setTimeout(20000);
        ftpClient.setControlEncoding(encoding);
        ftpClient.setMonitorInterval(1024L);
        ftpClient.setConnectMode(passive ? FTPConnectMode.PASV : FTPConnectMode.ACTIVE);
        ftpClient.setRetryCount(3);
        ftpClient.setRetryDelay(5000);
        ftpClient.setServerWakeupInterval(15000);
        ftpClient.setDeleteOnFailure(true);
        ftpClient.setTransferBufferSize(32768);
    }

    private static void connectFTPClient(FTPClient ftpClient) throws IOException, FTPException {
        PerformanceStats stats = PerformanceStats.getStats((String)"com.aptana.filesystem.ftp/perf/connect", (Object)FTPConnectionFileManager.class.getName());
        stats.startRun(ftpClient.getRemoteHost());
        try {
            ftpClient.connect();
        }
        finally {
            stats.endRun();
        }
    }

    protected void initAndAuthFTPClient(FTPClientInterface clientInterface, IProgressMonitor monitor) throws IOException, FTPException {
        if (clientInterface.connected()) {
            return;
        }
        FTPClient newFtpClient = (FTPClient)clientInterface;
        FTPConnectionFileManager.initFTPClient(newFtpClient, FTPConnectMode.PASV.equals(this.ftpClient.getConnectMode()), this.ftpClient.getControlEncoding());
        newFtpClient.setRemoteHost(this.host);
        newFtpClient.setRemotePort(this.port);
        Policy.checkCanceled(monitor);
        FTPConnectionFileManager.connectFTPClient(newFtpClient);
        monitor.worked(1);
        Policy.checkCanceled(monitor);
        newFtpClient.login(this.login, String.copyValueOf(this.password));
        monitor.worked(1);
    }

    protected static void setMessageLogger(FTPClient ftpClient, final PrintWriter writer) {
        FTPMessageListener listener = null;
        if (writer != null && ftpClient.getMessageListener() == null) {
            listener = new FTPMessageListener(){

                public void logCommand(String command) {
                    Matcher matcher;
                    if (command.startsWith("---> ")) {
                        command = command.substring(5);
                    }
                    if ((matcher = PASS_COMMAND_PATTERN.matcher(command)).matches()) {
                        command = matcher.replaceFirst("$1********");
                    }
                    writer.print("ftp> ");
                    writer.println(command);
                    writer.flush();
                }

                public void logReply(String reply) {
                    writer.println(reply);
                    writer.flush();
                }
            };
        }
        ftpClient.setMessageListener(listener);
    }

    public void connect(IProgressMonitor monitor) throws CoreException {
        Assert.isTrue((this.ftpClient != null ? 1 : 0) != 0, (String)Messages.FTPConnectionFileManager_not_initialized);
        monitor = Policy.monitorFor(monitor);
        try {
            this.cwd = null;
            this.cleanup();
            ConnectionContext context = CoreIOPlugin.getConnectionContext((Object)this);
            if (this.messageLogWriter == null) {
                if (context != null) {
                    Object object = context.get((Object)"command_log");
                    if (object instanceof PrintWriter) {
                        this.messageLogWriter = (PrintWriter)object;
                    } else if (object instanceof OutputStream) {
                        this.messageLogWriter = new PrintWriter((OutputStream)object);
                    }
                }
                if (this.messageLogWriter == null) {
                    this.messageLogWriter = FTPPlugin.getDefault().getFTPLogWriter();
                }
                if (this.messageLogWriter != null) {
                    this.messageLogWriter.println(MessageFormat.format("---------- FTP {0} ----------", this.host));
                    FTPConnectionFileManager.setMessageLogger(this.ftpClient, this.messageLogWriter);
                }
            } else {
                this.messageLogWriter.println(MessageFormat.format("---------- RECONNECTING - FTP {0} ----------", this.host));
            }
            monitor.beginTask(Messages.FTPConnectionFileManager_establishing_connection, -1);
            this.ftpClient.setRemoteHost(this.host);
            this.ftpClient.setRemotePort(this.port);
            while (true) {
                monitor.subTask(Messages.FTPConnectionFileManager_connecting);
                FTPConnectionFileManager.connectFTPClient(this.ftpClient);
                if (!(this.password.length != 0 || "anonymous".equals(this.login) || context != null && context.getBoolean("no_password_prompt"))) {
                    this.getOrPromptPassword(MessageFormat.format(Messages.FTPConnectionFileManager_ftp_auth, this.host), Messages.FTPConnectionFileManager_specify_password);
                }
                Policy.checkCanceled(monitor);
                monitor.subTask(Messages.FTPConnectionFileManager_authenticating);
                try {
                    this.ftpClient.login(this.login, String.copyValueOf(this.password));
                }
                catch (FTPException e) {
                    Policy.checkCanceled(monitor);
                    if (this.ftpClient.getLastValidReply() == null || "331".equals(this.ftpClient.getLastValidReply().getReplyCode())) {
                        if (context != null && context.getBoolean("no_password_prompt")) {
                            throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.ftp", MessageFormat.format(Messages.FTPConnectionFileManager_FailedAuthenticate, e.getLocalizedMessage()), (Throwable)e));
                        }
                        this.promptPassword(MessageFormat.format(Messages.FTPConnectionFileManager_ftp_auth, this.host), Messages.FTPConnectionFileManager_invalid_password);
                        this.safeQuit();
                        continue;
                    }
                    throw e;
                }
                break;
            }
            Policy.checkCanceled(monitor);
            this.changeCurrentDir(this.basePath);
            this.ftpClient.setType("ASCII".equals(this.transferType) ? FTPTransferType.ASCII : FTPTransferType.BINARY);
            if ((this.hasServerInfo || context != null && context.getBoolean("quick_connect")) && (context == null || !context.getBoolean("detect_timezone"))) {
                return;
            }
            try {
                this.getherServerInfo(context, monitor);
            }
            catch (OperationCanceledException e) {
                this.safeQuit();
                throw e;
            }
            catch (CoreException e) {
                this.safeQuit();
                throw e;
            }
            catch (UnknownHostException e) {
                this.safeQuit();
                throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.ftp", String.valueOf(Messages.FTPConnectionFileManager_HostNameNotFound) + e.getLocalizedMessage(), (Throwable)e));
            }
            catch (FileNotFoundException e) {
                this.safeQuit();
                throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.ftp", String.valueOf(Messages.FTPConnectionFileManager_RemoteFolderNotFound) + e.getLocalizedMessage(), (Throwable)e));
            }
            catch (Exception e) {
                this.safeQuit();
                throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.ftp", String.valueOf(Messages.FTPConnectionFileManager_connection_failed) + e.getLocalizedMessage(), (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void getherServerInfo(ConnectionContext context, IProgressMonitor monitor) {
        TimeZone tz;
        int i;
        Policy.checkCanceled(monitor);
        monitor.subTask(Messages.FTPConnectionFileManager_gethering_server_info);
        this.serverFeatures = null;
        try {
            String[] features = this.ftpClient.features();
            if (features != null && features.length > 0) {
                this.serverFeatures = new ArrayList<String>();
                int i2 = 0;
                while (i2 < features.length) {
                    String feature = features[i2].trim();
                    if (feature.indexOf(32) > 0) {
                        feature = feature.substring(0, feature.indexOf(32));
                    }
                    this.serverFeatures.add(feature);
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            e.getCause();
        }
        try {
            String[] validCodes = new String[]{"214"};
            FTPReply reply = this.ftpClient.sendCommand("SITE HELP");
            this.ftpClient.validateReply(reply, validCodes);
            if (this.serverFeatures == null) {
                this.serverFeatures = new ArrayList<String>();
            }
            String[] data = reply.getReplyData();
            i = 0;
            while (i < data.length) {
                String cmd = data[i].trim();
                if (!cmd.startsWith("214")) {
                    this.serverFeatures.add(MessageFormat.format("SITE {0}", cmd));
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.getCause();
        }
        Policy.checkCanceled(monitor);
        FTPFile[] rootFiles = null;
        try {
            rootFiles = this.listFiles((IPath)Path.ROOT, monitor);
        }
        catch (Exception reply) {
            // empty catch block
        }
        if (context != null && context.getBoolean("detect_timezone")) {
            this.serverToLocalTimeZoneShift = Integer.MIN_VALUE;
        } else if (this.timezone != null && (tz = TimeZone.getTimeZone(this.timezone)) != null) {
            long time = new Date().getTime();
            this.serverToLocalTimeZoneShift = TimeZone.getDefault().getOffset(time) - tz.getOffset(time);
        }
        if (this.serverToLocalTimeZoneShift == Integer.MIN_VALUE) {
            Policy.checkCanceled(monitor);
            try {
                FTPFile[] fTPFileArray;
                this.changeCurrentDir((IPath)Path.ROOT);
                FTPFile file = null;
                if (rootFiles != null) {
                    FTPFile[] fTPFileArray2 = rootFiles;
                    int cmd = rootFiles.length;
                    i = 0;
                    while (i < cmd) {
                        FTPFile ftpFile = fTPFileArray2[i];
                        if (ftpFile.isFile() && ftpFile.getName() != null && !ftpFile.getName().startsWith(".ht") && (ftpFile.lastModified().getHours() != 0 || ftpFile.lastModified().getMinutes() != 0 || ftpFile.lastModified().getSeconds() != 0)) {
                            file = ftpFile;
                            break;
                        }
                        ++i;
                    }
                }
                if (file == null && !Path.ROOT.equals((Object)this.basePath)) {
                    FTPFile[] ftpFiles;
                    fTPFileArray = ftpFiles = this.listFiles(this.basePath, monitor);
                    int n = ftpFiles.length;
                    int cmd = 0;
                    while (cmd < n) {
                        FTPFile ftpFile = fTPFileArray[cmd];
                        if (ftpFile.isFile() && ftpFile.getName() != null && !ftpFile.getName().startsWith(".ht") && (ftpFile.lastModified().getHours() != 0 || ftpFile.lastModified().getMinutes() != 0 || ftpFile.lastModified().getSeconds() != 0)) {
                            file = ftpFile;
                            break;
                        }
                        ++cmd;
                    }
                }
                Date lastModifiedLocal = null;
                if (file == null) {
                    this.changeCurrentDir(this.basePath);
                    lastModifiedLocal = new Date();
                    this.ftpClient.put((InputStream)new ByteArrayInputStream(new byte[0]), TMP_TIMEZONE_CHECK);
                    fTPFileArray = this.listFiles(this.basePath, monitor);
                    int n = fTPFileArray.length;
                    int cmd = 0;
                    while (cmd < n) {
                        FTPFile ftpFile = fTPFileArray[cmd];
                        if (TMP_TIMEZONE_CHECK.equals(ftpFile.getName())) {
                            file = ftpFile;
                            this.defaultOwner = ftpFile.getOwner();
                            this.defaultGroup = ftpFile.getGroup();
                            break;
                        }
                        ++cmd;
                    }
                }
                if (file != null) {
                    Date gmtTimeInLocalTZ;
                    Date serverTimeInLocalTZ = file.lastModified();
                    if (this.serverSupportsFeature("MDTM") && (gmtTimeInLocalTZ = this.ftpClient.modtime(file.getName())) != null) {
                        long serverToGmtShift = gmtTimeInLocalTZ.getTime() - gmtTimeInLocalTZ.getTime() % 60000L - (serverTimeInLocalTZ.getTime() - serverTimeInLocalTZ.getTime() % 60000L);
                        Calendar calendar = (Calendar)Calendar.getInstance().clone();
                        calendar.setTime(new Date());
                        this.serverToLocalTimeZoneShift = serverToGmtShift - (long)calendar.get(15) - (long)calendar.get(16);
                    }
                    if (this.serverToLocalTimeZoneShift == Integer.MIN_VALUE && lastModifiedLocal != null) {
                        long serverToLocalShift = lastModifiedLocal.getTime() - lastModifiedLocal.getTime() % 60000L - (serverTimeInLocalTZ.getTime() - serverTimeInLocalTZ.getTime() % 60000L);
                        long rem = serverToLocalShift % 900000L;
                        serverToLocalShift = rem < 450000L ? (serverToLocalShift -= rem) : (serverToLocalShift += 900000L - rem);
                        this.serverToLocalTimeZoneShift = serverToLocalShift;
                    }
                    if (TMP_TIMEZONE_CHECK.equals(file.getName())) {
                        this.ftpClient.delete(file.getName());
                    }
                    if (context != null && this.serverToLocalTimeZoneShift != Integer.MIN_VALUE) {
                        Calendar cal = (Calendar)Calendar.getInstance().clone();
                        cal.setTime(new Date());
                        int rawOffset = (int)((long)cal.get(15) - this.serverToLocalTimeZoneShift);
                        context.put((Object)"server_timezone", (Object)TimeZone.getAvailableIDs(rawOffset));
                    }
                }
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                FTPPlugin.log((IStatus)new Status(2, "com.aptana.filesystem.ftp", Messages.FTPConnectionFileManager_server_tz_check, (Throwable)e));
            }
            if (this.serverToLocalTimeZoneShift == Integer.MIN_VALUE) {
                this.serverToLocalTimeZoneShift = 0L;
            }
        }
        this.hasServerInfo = true;
    }

    protected void safeQuit() {
        try {
            if (this.ftpClient.connected()) {
                this.ftpClient.quit();
            }
        }
        catch (Exception e) {
            try {
                this.ftpClient.quitImmediately();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isConnected() {
        return this.ftpClient != null && this.ftpClient.connected();
    }

    public synchronized void disconnect(IProgressMonitor monitor) throws CoreException {
        if (!this.isConnected()) {
            return;
        }
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(Messages.FTPConnectionFileManager_closing_connection, -1);
        try {
            try {
                this.ftpClient.quit();
            }
            catch (Exception e) {
                try {
                    this.ftpClient.quitImmediately();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.cwd = null;
                this.pool.dispose();
                this.cleanup();
                monitor.done();
            }
        }
        finally {
            this.cwd = null;
            this.pool.dispose();
            this.cleanup();
            monitor.done();
        }
    }

    protected boolean serverSupportsFeature(String feature) {
        if (this.serverFeatures != null) {
            return this.serverFeatures.contains(feature);
        }
        return false;
    }

    protected void changeCurrentDir(IPath path) throws FTPException, IOException {
        try {
            if (this.cwd == null) {
                this.cwd = new Path(this.ftpClient.pwd());
            }
            if (!this.cwd.equals((Object)path)) {
                this.ftpClient.chdir(path.toPortableString());
                this.cwd = path;
            }
        }
        catch (FTPException e) {
            FTPConnectionFileManager.throwFileNotFound(e, path);
        }
        catch (IOException e) {
            this.cwd = null;
            throw e;
        }
    }

    private static void throwFileNotFound(FTPException e, IPath path) throws FileNotFoundException, FTPException {
        int code = e.getReplyCode();
        if (code == 550 || code == 450) {
            throw FTPConnectionFileManager.initFileNotFoundException((IPath)path, (Throwable)e);
        }
        throw e;
    }

    private static void fillFileInfo(ExtendedFileInfo fileInfo, FTPFile ftpFile) {
        fileInfo.setExists(true);
        fileInfo.setName(ftpFile.getName());
        fileInfo.setDirectory(ftpFile.isDir());
        fileInfo.setLength(ftpFile.size());
        fileInfo.setLastModified(ftpFile.lastModified() != null ? ftpFile.lastModified().getTime() : 0L);
        fileInfo.setOwner(ftpFile.getOwner());
        fileInfo.setGroup(ftpFile.getGroup());
        fileInfo.setPermissions(Policy.permissionsFromString(ftpFile.getPermissions()));
        if (ftpFile.isLink()) {
            fileInfo.setAttribute(32, true);
            fileInfo.setStringAttribute(64, ftpFile.getLinkedName().trim());
        }
    }

    private static ExtendedFileInfo createFileInfo(FTPFile ftpFile) {
        ExtendedFileInfo fileInfo = new ExtendedFileInfo(ftpFile.getName());
        FTPConnectionFileManager.fillFileInfo(fileInfo, ftpFile);
        return fileInfo;
    }

    protected void clearCache(IPath path) {
        super.clearCache(path);
        this.clearCacheAbsolute(this.basePath.append(path));
    }

    private void clearCacheAbsolute(IPath path) {
        int segments = path.segmentCount();
        for (IPath p : new ArrayList<IPath>(this.ftpFileCache.keySet())) {
            if (p.segmentCount() < segments || path.matchingFirstSegments(p) != segments) continue;
            this.ftpFileCache.remove(p);
        }
    }

    protected void interruptOperation() {
        try {
            if (this.ftpClient.connected()) {
                this.ftpClient.quitImmediately();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.interruptOperation();
    }

    protected boolean canUseTemporaryFile(IPath path, ExtendedFileInfo fileInfo, IProgressMonitor monitor) {
        if (super.canUseTemporaryFile(path, fileInfo, monitor)) {
            return !fileInfo.exists() || this.serverSupportsFeature("SITE CHMOD");
        }
        return false;
    }

    protected void checkConnected() throws Exception {
        if (this.ftpClient.connected()) {
            try {
                this.ftpClient.noOperation();
                this.ftpClient.setType(FTPTransferType.BINARY);
                return;
            }
            catch (FTPConnectionClosedException fTPConnectionClosedException) {
            }
            catch (FTPException fTPException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.ftpClient.quitImmediately();
        }
    }

    protected URI getRootCanonicalURI() {
        try {
            return new URI("ftp", this.login, this.host, this.port != 21 ? this.port : -1, Path.ROOT.toPortableString(), null, null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    protected ExtendedFileInfo fetchFile(IPath path, int options, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            IPath dirPath = path.removeLastSegments(1);
            String name = path.lastSegment();
            FTPFile result = this.ftpFileCache.get(path);
            if (result == null) {
                FTPFile[] ftpFiles;
                if ((options & 0x800) != 0) {
                    ExtendedFileInfo fileInfo = new ExtendedFileInfo(path.lastSegment());
                    try {
                        this.changeCurrentDir(path);
                        fileInfo.setExists(true);
                        fileInfo.setDirectory(true);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                    if (!fileInfo.exists()) {
                        fileInfo.setExists(this.existsFile(path));
                    }
                    return fileInfo;
                }
                FTPFile[] fTPFileArray = ftpFiles = this.listFiles(dirPath, monitor);
                int n = ftpFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileName;
                    FTPFile ftpFile = fTPFileArray[n2];
                    Date lastModifiedServerInLocalTZ = ftpFile.lastModified();
                    if (this.serverToLocalTimeZoneShift != 0L && lastModifiedServerInLocalTZ != null) {
                        ftpFile.setLastModified(new Date(lastModifiedServerInLocalTZ.getTime() + this.serverToLocalTimeZoneShift));
                    }
                    if ((fileName = ftpFile.getName()) == null || ".".equals(fileName) || "..".equals(fileName)) {
                        if (Path.ROOT.equals((Object)path) && ".".equals(fileName)) {
                            ftpFile.setName(path.toPortableString());
                            this.ftpFileCache.put(path, ftpFile);
                            result = ftpFile;
                        }
                    } else {
                        this.ftpFileCache.put(dirPath.append(fileName), ftpFile);
                        if (name != null && name.equalsIgnoreCase(fileName)) {
                            result = ftpFile;
                        }
                    }
                    ++n2;
                }
            }
            if ((options & 0x400) != 0 && result != null && !result.isDir() && name != null && result.lastModified().getSeconds() == 0 && this.serverSupportsFeature("MDTM")) {
                this.changeCurrentDir(dirPath);
                Policy.checkCanceled(monitor);
                try {
                    Date lastModifiedLocalTZ = this.ftpClient.modtime(name);
                    if (lastModifiedLocalTZ != null) {
                        result.setLastModified(lastModifiedLocalTZ);
                    }
                }
                catch (FTPException fTPException) {
                    // empty catch block
                }
            }
            if (result == null && Path.ROOT.equals((Object)path)) {
                result = new FTPFile("", path.toPortableString(), 0L, true, new Date(0L));
            }
            if (result != null) {
                return FTPConnectionFileManager.createFileInfo(result);
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.ftp", Messages.FTPConnectionFileManager_fetch_failed, (Throwable)e));
        }
        ExtendedFileInfo fileInfo = new ExtendedFileInfo(path.lastSegment());
        fileInfo.setExists(false);
        return fileInfo;
    }

    protected ExtendedFileInfo[] fetchFiles(IPath path, int options, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        monitor = Policy.subMonitorFor(monitor, 1);
        try {
            FTPFile[] ftpFiles = this.listFiles(path, monitor);
            monitor.beginTask(Messages.FTPConnectionFileManager_gethering_file_details, ftpFiles.length);
            ArrayList<ExtendedFileInfo> list = new ArrayList<ExtendedFileInfo>();
            FTPFile[] fTPFileArray = ftpFiles;
            int n = ftpFiles.length;
            int n2 = 0;
            while (n2 < n) {
                FTPFile ftpFile = fTPFileArray[n2];
                String fileName = ftpFile.getName();
                if (fileName == null || ".".equals(fileName) || "..".equals(fileName)) {
                    monitor.worked(1);
                } else {
                    Date lastModifiedServerInLocalTZ = ftpFile.lastModified();
                    if (this.serverToLocalTimeZoneShift != 0L && lastModifiedServerInLocalTZ != null) {
                        ftpFile.setLastModified(new Date(lastModifiedServerInLocalTZ.getTime() + this.serverToLocalTimeZoneShift));
                    }
                    if ((options & 0x400) != 0 && !ftpFile.isDir() && ftpFile.lastModified().getSeconds() == 0 && this.serverSupportsFeature("MDTM")) {
                        this.changeCurrentDir(path);
                        Policy.checkCanceled(monitor);
                        try {
                            Date lastModifiedLocalTZ = this.ftpClient.modtime(fileName);
                            if (lastModifiedLocalTZ != null) {
                                ftpFile.setLastModified(lastModifiedLocalTZ);
                            }
                        }
                        catch (FTPException lastModifiedLocalTZ) {
                            // empty catch block
                        }
                    }
                    IPath filePath = path.append(fileName);
                    this.ftpFileCache.put(filePath, ftpFile);
                    ExtendedFileInfo fileInfo = FTPConnectionFileManager.createFileInfo(ftpFile);
                    list.add(fileInfo);
                    monitor.worked(1);
                }
                ++n2;
            }
            ExtendedFileInfo[] extendedFileInfoArray = list.toArray(new ExtendedFileInfo[list.size()]);
            return extendedFileInfoArray;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.ftp", Messages.FTPConnectionFileManager_fetching_directory_failed, (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    protected String[] listDirectory(IPath path, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            FTPFile[] ftpFiles = this.listFiles(path, monitor);
            ArrayList<String> list = new ArrayList<String>();
            FTPFile[] fTPFileArray = ftpFiles;
            int n = ftpFiles.length;
            int n2 = 0;
            while (n2 < n) {
                FTPFile ftpFile = fTPFileArray[n2];
                String name = ftpFile.getName();
                if (name != null && !".".equals(name) && !"..".equals(name)) {
                    this.ftpFileCache.put(path.append(name), ftpFile);
                    list.add(name);
                }
                ++n2;
            }
            String[] stringArray = list.toArray(new String[list.size()]);
            return stringArray;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.ftp", Messages.FTPConnectionFileManager_listing_directory_failed, (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    protected InputStream readFile(IPath path, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        monitor.beginTask(Messages.FTPConnectionFileManager_initiating_download, 4);
        FTPClient downloadFtpClient = (FTPClient)this.pool.checkOut();
        try {
            this.initAndAuthFTPClient((FTPClientInterface)downloadFtpClient, monitor);
            Policy.checkCanceled(monitor);
            FTPConnectionFileManager.setMessageLogger(downloadFtpClient, this.messageLogWriter);
            downloadFtpClient.setType("ASCII".equals(this.transferType) ? FTPTransferType.ASCII : FTPTransferType.BINARY);
            try {
                downloadFtpClient.chdir(path.removeLastSegments(1).toPortableString());
            }
            catch (FTPException e) {
                FTPConnectionFileManager.throwFileNotFound(e, path.removeLastSegments(1));
            }
            monitor.worked(1);
            Policy.checkCanceled(monitor);
            try {
                FTPFileDownloadInputStream fTPFileDownloadInputStream = new FTPFileDownloadInputStream(this.pool, (FTPClientInterface)downloadFtpClient, (FileTransferInputStream)new FTPInputStream(downloadFtpClient, path.lastSegment()));
                return fTPFileDownloadInputStream;
            }
            catch (FTPException e) {
                try {
                    FTPConnectionFileManager.throwFileNotFound(e, path);
                }
                catch (Exception e2) {
                    FTPConnectionFileManager.setMessageLogger(downloadFtpClient, null);
                    this.pool.checkIn(downloadFtpClient);
                    if (e2 instanceof OperationCanceledException) {
                        throw (OperationCanceledException)((Object)e2);
                    }
                    if (e2 instanceof FileNotFoundException) {
                        throw (FileNotFoundException)e2;
                    }
                    throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.ftp", Messages.FTPConnectionFileManager_opening_file_read_failed, (Throwable)e2));
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                monitor.done();
                return null;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected OutputStream writeFile(final IPath path, boolean useTemporary, long permissions, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        monitor.beginTask(Messages.FTPConnectionFileManager_initiating_file_upload, 4);
        FTPClient uploadFtpClient = (FTPClient)this.pool.checkOut();
        try {
            this.initAndAuthFTPClient((FTPClientInterface)uploadFtpClient, monitor);
            Policy.checkCanceled(monitor);
            FTPConnectionFileManager.setMessageLogger(uploadFtpClient, this.messageLogWriter);
            uploadFtpClient.setType("ASCII".equals(this.transferType) ? FTPTransferType.ASCII : FTPTransferType.BINARY);
            IPath dirPath = path.removeLastSegments(1);
            try {
                uploadFtpClient.chdir(dirPath.toPortableString());
            }
            catch (FTPException e) {
                FTPConnectionFileManager.throwFileNotFound(e, dirPath);
            }
            monitor.worked(1);
            Policy.checkCanceled(monitor);
            FTPFileUploadOutputStream fTPFileUploadOutputStream = new FTPFileUploadOutputStream(this.pool, (FTPClientInterface)uploadFtpClient, (FileTransferOutputStream)new FTPOutputStream(uploadFtpClient, useTemporary ? FTPConnectionFileManager.generateTempFileName(path.lastSegment()) : path.lastSegment()), useTemporary ? path.lastSegment() : null, null, permissions, new Runnable(){

                public void run() {
                    FTPConnectionFileManager.this.clearCacheAbsolute(path);
                }
            });
            return fTPFileUploadOutputStream;
        }
        catch (Exception e) {
            FTPConnectionFileManager.setMessageLogger(uploadFtpClient, null);
            this.pool.checkIn(uploadFtpClient);
            if (e instanceof OperationCanceledException) {
                throw (OperationCanceledException)((Object)e);
            }
            if (e instanceof FileNotFoundException) {
                throw (FileNotFoundException)e;
            }
            if (e instanceof FTPException && ((FTPException)((Object)e)).getReplyCode() == 553) {
                throw FTPConnectionFileManager.initFileNotFoundException((IPath)path, (Throwable)e);
            }
            throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.ftp", Messages.FTPConnectionFileManager_opening_file_write_failed, (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    protected void deleteDirectory(IPath path, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        MultiStatus status = new MultiStatus("com.aptana.filesystem.ftp", 0, null, null);
        try {
            try {
                IPath dirPath = path.removeLastSegments(1);
                this.changeCurrentDir(dirPath);
                Policy.checkCanceled(monitor);
                this.recursiveDeleteTree(path, monitor, status);
                this.changeCurrentDir(dirPath);
                this.ftpClient.rmdir(path.lastSegment());
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                if (status.isOK()) {
                    throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.ftp", Messages.FTPConnectionFileManager_deleting_directory_failed, (Throwable)e));
                }
                MultiStatus multiStatus = new MultiStatus("com.aptana.filesystem.ftp", 0, Messages.FTPConnectionFileManager_deleting_directory_failed, (Throwable)e);
                multiStatus.addAll((IStatus)status);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void deleteFile(IPath path, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            try {
                IPath dirPath = path.removeLastSegments(1);
                this.changeCurrentDir(dirPath);
                Policy.checkCanceled(monitor);
                try {
                    this.ftpClient.delete(path.lastSegment());
                }
                catch (FTPException e) {
                    if (e.getReplyCode() == 532) {
                        throw new PermissionDeniedException(path.toPortableString(), (Exception)((Object)e));
                    }
                    throw e;
                }
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.ftp", MessageFormat.format(Messages.FTPConnectionFileManager_deleting_failed, path), (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void createFile(IPath path, IProgressMonitor monitor) throws CoreException, FileNotFoundException, PermissionDeniedException {
        try {
            try {
                IPath dirPath = path.removeLastSegments(1);
                this.changeCurrentDir(dirPath);
                Policy.checkCanceled(monitor);
                try {
                    this.ftpClient.put((InputStream)new ByteArrayInputStream(new byte[0]), path.lastSegment());
                }
                catch (FTPException e) {
                    if (e.getReplyCode() == 532) {
                        throw new PermissionDeniedException(path.toPortableString(), (Exception)((Object)e));
                    }
                    throw e;
                }
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.ftp", MessageFormat.format(Messages.FTPConnectionFileManager_CreateFile0Failed, path), (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void createDirectory(IPath path, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            try {
                this.changeCurrentDir(path);
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    this.ftpClient.mkdir(path.toPortableString());
                    if (PreferenceUtils.getUpdatePermissions((PermissionDirection)PermissionDirection.UPLOAD) && PreferenceUtils.getSpecificPermissions((PermissionDirection)PermissionDirection.UPLOAD)) {
                        this.changeFilePermissions(path, PreferenceUtils.getFolderPermissions((PermissionDirection)PermissionDirection.UPLOAD), monitor);
                    }
                }
                catch (FTPException e) {
                    FTPConnectionFileManager.throwFileNotFound(e, path);
                }
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.ftp", Messages.FTPConnectionFileManager_creating_directory_failed, (Throwable)e));
        }
    }

    protected void renameFile(IPath sourcePath, IPath destinationPath, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            try {
                this.changeCurrentDir(sourcePath.removeLastSegments(1));
                Policy.checkCanceled(monitor);
                try {
                    this.ftpClient.rename(sourcePath.toPortableString(), destinationPath.toPortableString());
                }
                catch (FTPException e) {
                    FTPConnectionFileManager.throwFileNotFound(e, sourcePath);
                    throw e;
                }
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.ftp", Messages.FTPConnectionFileManager_renaming_failed, (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void renameDirectory(IPath sourcePath, IPath destinationPath, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        this.renameFile(sourcePath, destinationPath, monitor);
    }

    protected void setModificationTime(IPath path, long modificationTime, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        block13: {
            if (!this.serverSupportsFeature("MFMT") && !this.serverSupportsFeature("SITE UTIME")) {
                return;
            }
            try {
                try {
                    IPath dirPath = path.removeLastSegments(1);
                    this.changeCurrentDir(dirPath);
                    Policy.checkCanceled(monitor);
                    if (this.serverSupportsFeature("MFMT")) {
                        this.ftpClient.setModTime(path.lastSegment(), new Date(modificationTime));
                        break block13;
                    }
                    if (!this.serverSupportsFeature("SITE UTIME")) break block13;
                    Calendar cal = Calendar.getInstance();
                    long localTimezoneShift = cal.get(15) + cal.get(16);
                    Date date = new Date(modificationTime - localTimezoneShift);
                    if (this.utimeFormat == -1) {
                        this.utimeFormat = 0;
                        while (this.utimeFormat < UTIME_FORMATS.length) {
                            String format = UTIME_FORMATS[this.utimeFormat].format(date);
                            FTPReply reply = this.ftpClient.sendCommand("SITE " + MessageFormat.format(format, path.lastSegment()));
                            if (!"500".equals(reply.getReplyCode()) && !"501".equals(reply.getReplyCode())) {
                                break block13;
                            }
                            ++this.utimeFormat;
                        }
                        break block13;
                    }
                    if (this.utimeFormat >= 0 && this.utimeFormat < UTIME_FORMATS.length) {
                        String format = UTIME_FORMATS[this.utimeFormat].format(date);
                        this.ftpClient.site(MessageFormat.format(format, path.lastSegment()));
                    }
                }
                catch (FileNotFoundException e) {
                    throw e;
                }
                catch (OperationCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.ftp", Messages.FTPConnectionFileManager_set_modification_time_failed, (Throwable)e));
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    protected void changeFilePermissions(IPath path, long permissions, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        if (!this.serverSupportsFeature("SITE CHMOD")) {
            return;
        }
        try {
            try {
                IPath dirPath = path.removeLastSegments(1);
                this.changeCurrentDir(dirPath);
                Policy.checkCanceled(monitor);
                this.ftpClient.site(MessageFormat.format("CHMOD {0} {1}", Long.toOctalString(permissions), path.lastSegment()));
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.ftp", Messages.FTPConnectionFileManager_FailedSetPermissions, (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void changeFileGroup(IPath path, String group, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        if (!this.serverSupportsFeature("SITE CHGRP")) {
            return;
        }
        try {
            try {
                IPath dirPath = path.removeLastSegments(1);
                this.changeCurrentDir(dirPath);
                Policy.checkCanceled(monitor);
                this.ftpClient.site(MessageFormat.format("CHGRP {0} {1}", group, path.lastSegment()));
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.ftp", Messages.FTPConnectionFileManager_FailedSetGroup, (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean existsFile(IPath filePath) throws IOException, FTPException {
        return this.ftpClient.existsFile(filePath.toPortableString());
    }

    private FTPFile[] ftpSTAT(String dirname) throws IOException, FTPException, ParseException {
        FTPFile[] ftpFiles;
        this.setupFileFactory();
        String[] validCodes = new String[]{"211", "212", "213"};
        FTPReply reply = this.ftpClient.sendCommand("STAT " + dirname);
        this.ftpClient.validateReply(reply, validCodes);
        String[] data = reply.getReplyData();
        if (data == null) {
            return null;
        }
        int i = 0;
        while (i < data.length) {
            data[i] = data[i].trim();
            ++i;
        }
        FTPFile[] fTPFileArray = ftpFiles = this.fileFactory.parse(data);
        int n = ftpFiles.length;
        int n2 = 0;
        while (n2 < n) {
            FTPFile ftpFile = fTPFileArray[n2];
            String name = ftpFile.getName();
            if (name != null && name.indexOf(47) != -1) {
                ftpFile.setName(Path.fromPortableString((String)name).lastSegment());
            }
            ++n2;
        }
        return ftpFiles;
    }

    private FTPFile[] ftpLIST(IPath dirPath, IProgressMonitor monitor) throws IOException, ParseException, FTPException {
        this.setupFileFactory();
        this.changeCurrentDir(dirPath);
        Policy.checkCanceled(monitor);
        if (!Boolean.FALSE.equals(this.listASupported)) {
            try {
                FTPFile[] ftpFiles = this.fileFactory.parse(this.ftpClient.dir("-a", true));
                this.listASupported = Boolean.TRUE;
                return ftpFiles;
            }
            catch (FTPException e) {
                if (this.listASupported == null && e.getReplyCode() >= 500) {
                    this.listASupported = Boolean.FALSE;
                }
                throw e;
            }
        }
        return this.fileFactory.parse(this.ftpClient.dir(".", true));
    }

    private void setupFileFactory() throws IOException, FTPException {
        if (this.fileFactory == null) {
            try {
                this.fileFactory = new FTPFileFactory(this.ftpClient.system());
            }
            catch (FTPException ex) {
                this.fileFactory = new FTPFileFactory("UNIX");
            }
            this.fileFactory.setLocales(FTPClient.DEFAULT_LISTING_LOCALES);
        }
    }

    private FTPFile[] listFiles(IPath dirPath, IProgressMonitor monitor) throws IOException, ParseException, FTPException {
        FTPFile[] ftpFiles = null;
        if (!Boolean.FALSE.equals(this.statSupported) && dirPath.toPortableString().indexOf(32) == -1) {
            block13: {
                try {
                    ftpFiles = this.ftpSTAT(dirPath.addTrailingSeparator().toPortableString());
                }
                catch (MalformedReplyException e) {
                    this.statSupported = Boolean.FALSE;
                }
                catch (FTPException e) {
                    if (e.getReplyCode() == 501 || e.getReplyCode() == 502 || e.getReplyCode() == 504) {
                        this.statSupported = null;
                    }
                    if (!Boolean.TRUE.equals(this.statSupported) || e.getReplyCode() == 500 || e.getReplyCode() == 550) break block13;
                    FTPConnectionFileManager.throwFileNotFound(e, dirPath);
                }
            }
            if (ftpFiles == null || ftpFiles.length == 0) {
                if (this.statSupported == null) {
                    this.statSupported = Boolean.FALSE;
                }
                return this.ftpLIST(dirPath, monitor);
            }
            if (ftpFiles[0].isLink()) {
                return this.ftpLIST(dirPath, monitor);
            }
            if (this.statSupported == null) {
                this.statSupported = Boolean.TRUE;
            }
        } else {
            ftpFiles = this.ftpLIST(dirPath, monitor);
        }
        if (this.fileFactory.getSystem().toUpperCase().startsWith(WINDOWS_STR) && ftpFiles != null) {
            FTPFile[] fTPFileArray = ftpFiles;
            int n = ftpFiles.length;
            int n2 = 0;
            while (n2 < n) {
                FTPFile ftpFile = fTPFileArray[n2];
                if (ftpFile.getPermissions() == null) {
                    ftpFile.setPermissions("-rw-r-----");
                }
                ++n2;
            }
        }
        return ftpFiles;
    }

    private void recursiveDeleteTree(IPath path, IProgressMonitor monitor, MultiStatus status) throws IOException, ParseException {
        try {
            this.changeCurrentDir(path);
            FTPFile[] ftpFiles = this.listFiles(path, monitor);
            ArrayList<String> dirs = new ArrayList<String>();
            FTPFile[] fTPFileArray = ftpFiles;
            int n = ftpFiles.length;
            int n2 = 0;
            while (n2 < n) {
                FTPFile ftpFile = fTPFileArray[n2];
                String name = ftpFile.getName();
                if (name != null && !".".equals(name) && !"..".equals(name)) {
                    if (ftpFile.isDir()) {
                        dirs.add(name);
                    } else {
                        Policy.checkCanceled(monitor);
                        monitor.subTask(path.append(name).toPortableString());
                        try {
                            this.ftpClient.delete(name);
                        }
                        catch (FTPException e) {
                            status.add((IStatus)new Status(4, "com.aptana.filesystem.ftp", MessageFormat.format(Messages.FTPConnectionFileManager_deleting_failed, path.append(name).toPortableString()), (Throwable)e));
                        }
                        monitor.worked(1);
                    }
                }
                ++n2;
            }
            for (String name : dirs) {
                monitor.subTask(path.append(name).toPortableString());
                this.recursiveDeleteTree(path.append(name), monitor, status);
                Policy.checkCanceled(monitor);
                this.changeCurrentDir(path);
                Policy.checkCanceled(monitor);
                this.ftpClient.rmdir(name);
                monitor.worked(1);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            status.add((IStatus)new Status(4, "com.aptana.filesystem.ftp", MessageFormat.format(Messages.FTPConnectionFileManager_deleting_failed, path.toPortableString()), (Throwable)e));
        }
    }

    private static String generateTempFileName(String base) {
        StringBuffer sb = new StringBuffer();
        sb.append(base).append("._tmp_upload");
        String ext = Path.fromPortableString((String)base).getFileExtension();
        if (ext != null) {
            sb.append(ext);
        }
        return sb.toString();
    }

    public FTPClient newClient() {
        return new ProFTPClient();
    }
}

